/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.util.data;

import icyllis.annotations.NotNull;
import icyllis.annotations.Nullable;
import icyllis.flexmark.util.data.DataHolder;
import icyllis.flexmark.util.data.DataKeyBase;
import icyllis.flexmark.util.data.DataNotNullValueFactory;
import icyllis.flexmark.util.data.MutableDataHolder;
import icyllis.flexmark.util.data.NotNullValueSupplier;

public class DataKey<T>
extends DataKeyBase<T> {
    public DataKey(@NotNull String name, @NotNull T defaultValue, @NotNull DataNotNullValueFactory<T> factory) {
        super(name, defaultValue, factory);
    }

    public DataKey(@NotNull String name, @NotNull NotNullValueSupplier<T> supplier) {
        super(name, supplier.get(), (DataHolder holder) -> supplier.get());
    }

    public DataKey(@NotNull String name, @NotNull DataKey<T> defaultKey) {
        this(name, defaultKey.getDefaultValue(), defaultKey::get);
    }

    public DataKey(@NotNull String name, @NotNull T defaultValue) {
        this(name, defaultValue, (DataHolder options) -> defaultValue);
    }

    @Override
    @NotNull
    public DataNotNullValueFactory<T> getFactory() {
        return (DataNotNullValueFactory)super.getFactory();
    }

    @Override
    @NotNull
    public T getDefaultValue() {
        return super.getDefaultValue();
    }

    @Override
    @NotNull
    public T getDefaultValue(@NotNull DataHolder holder) {
        return super.getDefaultValue(holder);
    }

    @Override
    @NotNull
    public T get(@Nullable DataHolder holder) {
        return super.get(holder);
    }

    @Override
    @NotNull
    public MutableDataHolder set(@NotNull MutableDataHolder dataHolder, @NotNull T value) {
        return dataHolder.set(this, value);
    }

    @Override
    public String toString() {
        T defaultValue = this.getDefaultValue();
        return "DataKey<" + defaultValue.getClass().getSimpleName() + "> " + this.getName();
    }
}

